﻿package org.pizarra.Animation {
	
	import flash.display.*;
	import fl.controls.*;
	import flash.events.Event;
	import flash.utils.Dictionary;
	import org.pizarra.Entity.*;
	import org.pizarra.graficos.Image;
	import fl.events.*;
	import com.greensock.*;
	import org.pizarra.util.*;
	import org.pizarra.helpers.SoundPlayer;
	import org.pizarra.configuracion.Settings;
	import flash.geom.Point;
	import org.pizarra.graficos.TrayectoriaSprite;
	import org.pizarra.Trayectoria;
	import org.pizarra.graficos.PathSprite;
	
	public class ExerciseAnimation extends Sprite {
		
		private var ej: EjercicioBE;
		private var fondo: FondoBE;
		private var hElementos: Dictionary;
		private var hAcciones: Dictionary;
		
		private var audioLengths: Array = new Array();
		private var audios: Array = new Array();
		private var els: Array = new Array();
		private var paths: Array = new Array();
		//private var actions: Array = new Array();
		private var preActions: Array = new Array();
		private var postActions: Array = new Array();
		private var preActionImages: Array = new Array();
		private var postActionImages: Array = new Array();
		
		private var widths: Array = new Array();
		private var heights: Array = new Array();
		
		private var tl: Array = new Array();
		private var _length: int;
		private var _scene: int = 1;
		
		private var _sceneLimits: Array = new Array();
		private var _aggregateLength: Number = 0.0;
		
		private var timelines: Array = new Array();
		private var masterTimeline: TimelineMax;
		
		private var isPlaying: Boolean = true;
		
		
		public function ExerciseAnimation() {
			
		}
		
		public function Init(ej: EjercicioBE, fondo: FondoBE, hElementos: Dictionary, hAcciones: Dictionary):void {
			this.ej = ej;
			this.fondo = fondo;
			this.hElementos = hElementos;
			this.hAcciones = hAcciones;
			
			//	Draw the backgound
			addChild(new Image(fondo.url, fondo.altura, fondo.anchura));
			
			//	Place Elements
			PlaceElementImages();
			PrepareAudios();
			_scene = 1;
		}
		
		/*	Private functions
		 ================================================================*/
		private function PlaceElementImages():void {
			
			var prop: Number = fondo.altura / fondo.altura_m;
			if (ej.escenas.length == 0) return;
			
			var escena: EscenaBE = ej.escenas[1];
			var j = 0;
			
			for each(var m: MovimientoBE in escena.movimientos) {
				var el: ElementoBE = hElementos[m.elemento];
				var img: Image = new Image(el.imagen, el.anchura * prop, el.altura * prop);
				
				widths.push(el.anchura * prop / 2);
				heights.push(el.altura * prop / 2);
				img.x = m.inicio.x;
				img.y = m.inicio.y;
				addChild(img);
				els.push(img);
				
				var preAction: TextInput = new TextInput(),
				postAction: TextInput = new TextInput();
			
				preAction.alpha = 0;
				//preAction.y = el.altura * prop;
				img.addChild(preAction);
				preActions.push(preAction);
				
				postAction.alpha = 0;
				//postAction.y = el.altura * prop;
				img.addChild(postAction);
				postActions.push(postAction);
			
				PrepareActions(m, el, img);
				
				j++;
			}
			
			for(var i: uint = 1; i < ej.escenas.length; i++){
				
				var es: EscenaBE = ej.escenas[i];
				preActionImages[i] = new Array();
				postActionImages[i] = new Array();
				for(var k: uint = 0; k < es.movimientos.length; k++){
					
					var mov: MovimientoBE = es.movimientos[k];
					
					if(mov.preAccion != null && mov.preAccion != GUID.Empty
					   	&& hAcciones[mov.preAccion].url != null && hAcciones[mov.preAccion].url != "" ){
						var url: String = hAcciones[mov.preAccion].url;
						if( url != null && url != "" && url != "null"){
							preActionImages[i][k] = new Image(Ficheros.BASE_ACTIONS + url, 40, 40);
							preActionImages[i][k].alpha = 0;
							//preActionImages[i][k].y = el.altura * prop;
							img.addChild(preActionImages[i][k]);
						}else{
							preActionImages[i][k] = null;
						}
					}
					if(mov.postAccion != null && mov.postAccion != GUID.Empty
					   	&& hAcciones[mov.postAccion].url != null && hAcciones[mov.postAccion].url != "" ){
						var url: String = hAcciones[mov.postAccion].url;
						if( url != null && url != "" && url != "null"){
							postActionImages[i][k] = new Image(Ficheros.BASE_ACTIONS + url, 40, 40);
							postActionImages[i][k].alpha = 0;
							img.addChild(postActionImages[i][k]);
						}else{
							postActionImages[i][k] = null;
						}
					}
				}
			}
			
			setActionsForScene();
		}
		
		private function PrepareActions(m: MovimientoBE, el: ElementoBE, img: Image):void{
			//	Create action labels
			/*var preAction: TextInput = new TextInput(),
				postAction: TextInput = new TextInput();
			var prop: Number = fondo.altura / fondo.altura_m;
			
			preAction.alpha = 0;
			preAction.y = el.altura * prop;
			img.addChild(preAction);
			preActions.push(preAction);
			
			postAction.alpha = 0;
			postAction.y = el.altura * prop;
			img.addChild(postAction);
			postActions.push(postAction);*/
		
		}
		
		private function PrepareAudios():void {
			
			//	Init
			for (var i = 1; i < ej.escenas.length; i += 1 ) {
				var esc: EscenaBE = ej.escenas[i];
				esc.audio = esc.audio.split("\\\\").join("\\");
				if (esc.audio == null || esc.audio == "") {
					audioLengths[i] = 0;
				}else {
					audioLengths[i] = -1;
					audios[i] = new SoundPlayer(esc.audio);
					audios[i].addEventListener(Event.COMPLETE, SoundLoaded);
				}
			}
			CheckAudiosLoaded();
		}
		
		private function SoundLoaded(ev:Event) {
			
			var n: int = audios.indexOf(ev.target) ;
			audioLengths[n] = ev.target.Length;
			CheckAudiosLoaded();
		}
		
		private function CheckAudiosLoaded():void {
			//	Check if the rest of the audios has been loaded
			for (var i = 1; i < ej.escenas.length; i += 1 ) {
				if (audioLengths[i] == -1) return;
			}
			_length = 0;	//	In seconds
			//	Postprocesa duración
			for (var i = 1; i < ej.escenas.length; i += 1 ) {
				var escena: EscenaBE = ej.escenas[i];
				var len: int = Math.ceil(audioLengths[i] / 1000);
				var duracionReal = (escena.tipo == Constantes.SERIE)
									? escena.movimientos.length * escena.duracion
									: escena.duracion;
									
				//trace("duracion de la escena : " + duracionReal);
				//trace("duracion del audio : " + len);
				
				_length += (duracionReal < len) 
									? len
									: duracionReal;
									
				if (duracionReal < len){
					ej.escenas[i].duracion = Math.max(len, duracionReal);
				}
				//trace("esc: " + ej.escenas[i].duracion);
				
			}
			//trace("len: " + _length);
			Do();
			dispatchEvent(new Event(Event.COMPLETE));
		}
		
		
		private function generateZigZagAnimation(m: MovimientoBE, i: uint, j: uint, duration: Number): TimelineLite{
			
			var altura: Number = heights[j]
				, anchura: Number = widths[j]
				, tl: TimelineLite = new TimelineLite()
				, target: DisplayObject;
			
			if(m.inicio.x == -1000){
				tl.append(new TweenLite(els[j], Settings.ElementFadeInterval, { alpha: 0 } ));
				return tl;
			}
			
			tl.append(new TweenLite(paths[i][j], Settings.PathFadeInterval, { alpha: 1 } ));
			for(var l: uint = 0; l < m.trayectoria.length; l++) {
				var tr: TrayectoriaBE = m.trayectoria[l]
					, t :Number = duration / m.trayectoria.length;
					
				if(l == 0 && m.preAccion!= null && m.preAccion != GUID.Empty){
					
					target = (hAcciones[m.preAccion].url != null && hAcciones[m.preAccion].url != "null")
									? preActionImages[i][j]
									: preActions[j];
					
					tl.append(new TweenLite(target, Settings.ActionFadeInterval, { alpha: 1 } ));
					tl.append(new TweenLite(target, Settings.ActionShowInterval, { scaleX: 1 } ));
					tl.append(new TweenLite(target, Settings.ActionFadeInterval, { alpha: 0 } ));
				}
				tl.append(new TweenLite(els[j], t, { x:tr.punto.x - widths[j], y: tr.punto.y - heights[j] } ));
			}
			if( m.postAccion!= null && m.postAccion != GUID.Empty){
				//	Post acción
				target = (hAcciones[m.postAccion].url != null && hAcciones[m.postAccion].url != "null")
							? postActionImages[i][j]
							: postActions[j];
				tl.append(new TweenLite(target, Settings.ActionFadeInterval, { alpha: 1 } ));
				tl.append(new TweenLite(target, Settings.ActionShowInterval, { scaleX: 1 } ));
				tl.append(new TweenLite(target, Settings.ActionFadeInterval, { alpha: 0 } ));
			}
			tl.append(new TweenLite(paths[i][j], Settings.PathFadeInterval, { alpha: 0 } ));
			return tl;
		}
		
		private function generateBezierAnimation(m: MovimientoBE, i: uint, j: uint, duration: Number): TimelineLite{
			var dibujo: Array = generateBezier(m, j)
				, tl: TimelineLite = new TimelineLite()
				, target: DisplayObject;
			
			if(m.inicio.x == -1000){
				tl.append(new TweenLite(els[j], Settings.ElementFadeInterval, { alpha: 0 } ));
				return tl;
			}
			
			target = (hAcciones[m.preAccion].url != null && hAcciones[m.preAccion].url != "null")
									? preActionImages[i][j]
									: preActions[j];
					tl.append(new TweenLite(paths[i][j], Settings.PathFadeInterval, { alpha: 1 } ));
					tl.append(new TweenLite(target, Settings.ActionFadeInterval, { alpha: 1 } ));
					tl.append(new TweenLite(target, Settings.ActionShowInterval, { scaleX: 1 } ));
					tl.append(new TweenLite(target, Settings.ActionFadeInterval, { alpha: 0 } ));
					
			tl.append(TweenMax.to(els[j], duration, {bezier: dibujo}));
			//	Post acción
			target = (hAcciones[m.postAccion].url != null && hAcciones[m.postAccion].url != "null")
						? postActionImages[i][j]
						: postActions[j];
			tl.append(new TweenLite(target, Settings.ActionFadeInterval, { alpha: 1 } ));
			tl.append(new TweenLite(target, Settings.ActionShowInterval, { scaleX: 1 } ));
			tl.append(new TweenLite(target, Settings.ActionFadeInterval, { alpha: 0 } ));
			tl.append(new TweenLite(paths[i][j], Settings.PathFadeInterval, { alpha: 0 } ));
			
			return tl;
		}
		
		private function generateParalellScene(esc: EscenaBE, i: uint): void{
			var j: uint = 0;
			for each(var m: MovimientoBE in esc.movimientos) {	
				
				paths[i][j] = new PathSprite(els[j], m, m.inicio);
				paths[i][j].alpha = 0;
				this.addChild(paths[i][j]);
				
				if(m.tipo == "001" || m.tipo == "002"){
					timelines[i].insert(generateZigZagAnimation(m,i,j, esc.duracion));
				}
						
				if(m.tipo == "003" || m.tipo == "004"){
					timelines[i].insert(generateBezierAnimation(m,i,j, esc.duracion));
				}
				j++;
			}		
		}
		
		private function generateSerialScene(esc: EscenaBE, i: uint): void{
			var tweenArray: Array = new Array();
			for (var j = 0; j < esc.movimientos.length; j += 1 ) {
				
				var m:MovimientoBE = esc.movimientos[j];
				paths[i][j] = new PathSprite(els[j], m, m.inicio);
				paths[i][j].alpha = 0;
				this.addChild(paths[i][j]);
					
				if(m.tipo == "001" || m.tipo == "002"){			//	ZigZags
					timelines[i].append(this.generateZigZagAnimation(m,i,j,esc.duracion));
				}
				if(m.tipo == "003" || m.tipo == "004"){			//	Beziers
					timelines[i].append(this.generateBezierAnimation(m,i,j,esc.duracion));
				}
			}
		}
		
		private function Do() {
			masterTimeline = new TimelineMax({onComplete:masterTimeline_Complete});
			var timer: Number = 0.0;
			
			for (var i = 1; i < ej.escenas.length; i++ ) {
				var aux: Number = _aggregateLength 
					, esc: EscenaBE = ej.escenas[i]
					, j = 0;
				
				timelines[i] = new TimelineMax({onComplete:sceneTimeline_Complete, onUpdate: cambio_frame});
				paths[i] = new Array();
				masterTimeline.addLabel( i + "", _aggregateLength);
				
				if (esc.tipo == Constantes.PARALELO) {
					this.generateParalellScene(esc,i);
				}
				if (esc.tipo == Constantes.SERIE) {
					this.generateSerialScene(esc,i);
				}
				
				masterTimeline.append(timelines[i]);
				_aggregateLength += timelines[i].totalDuration;
			}
			if(audioLengths[_scene] != 0){
				audios[_scene].Play();
			}
			//	Move elements to top
			for(var i: uint = 0; i< els.length; i++){
				this.addChild(els[i]);
			}
		}
		
		private function sceneTimeline_Complete():void{
			_scene = (int)(masterTimeline.currentLabel);
			setActionsForScene();	//	Change actions
			if(_scene < ej.escenas.length){
				if(audioLengths[_scene] != 0){
					audios[_scene].Play();
				}
				this.dispatchEvent(new Event("Scene_Change"));
			}
			//	Move elements to top
			for(var i: uint = 0; i< els.length; i++){
				this.addChild(els[i]);
			}
		}
		
		private function setActionsForScene(): void{
			var movimientos: Array = ej.escenas[_scene].movimientos;
			for(var i = 0; i < movimientos.length; i++){
				var mov: MovimientoBE = movimientos[i];
				var auxAcc: AccionBE;
				if( mov.preAccion != null && mov.preAccion != GUID.Empty && hAcciones[mov.preAccion] != null){
					auxAcc = hAcciones[mov.preAccion];
					preActions[i].text = auxAcc.nombre;
				}
				if( mov.postAccion != null && mov.postAccion != GUID.Empty && hAcciones[mov.postAccion] != null){
					auxAcc = hAcciones[mov.postAccion];
					postActions[i].text = auxAcc.nombre;
				}
			}
		}
		
		private function masterTimeline_Complete():void{
			isPlaying = false;
			trace("done");
		}
		
		/*	Public Interface
		 ================================================================*/
		//	Play
		public function Play() {
			masterTimeline.play();
			isPlaying = true;
		}
		
		public function Pause(){
			masterTimeline.pause();
			isPlaying = false;
		}
		
		public function Resume(){
			masterTimeline.play();
			isPlaying = true;
		}
		
		public function Stop(){
			masterTimeline.stop();
			isPlaying = false;
		}
		
		public function set CurrentProgress(val: Number):void {
			masterTimeline.gotoAndStop(val / 1000);
			_scene = (int)(masterTimeline.currentLabel);
			setActionsForScene();
			if(isPlaying){
				masterTimeline.play();
			}
		}
		
		public function get Length(): Number { 
			return masterTimeline.totalDuration;
		}
		
		public function get CurrentProgress() { return masterTimeline.currentTime; }
		public function get Scene() { return _scene; }
		
		public function set Speed(val: Number): void {
			this.masterTimeline.timeScale = val;
			if(isPlaying){
				masterTimeline.play();
			}
		}
		public function Reverse(): void {
			this.masterTimeline.reversed = !this.masterTimeline.reversed;
		}
		
		/*	HANDLERS
		 =================================================================*/
		private function cambio_frame() {
			dispatchEvent(new Event(Event.CHANGE));
		}
		
		private function scene_Start():void{
			trace("scene start");
		}
		
		/*	PRIVATE
		*/
		//	Generate bezier points
		private function generateBezier(m: MovimientoBE, j){
			
			var dibujo: Array = new Array();
			var elem = new Array();
			var tr : Array = m.trayectoria;
			var altura = heights[j];
			var anchura = widths[j];
			
			for(var i:int = 1; i<=tr.length-1; i++){
				elem[i] = new Object();
				elem[i]["x"] = tr[i].punto.x - anchura;
				elem[i]["y"] = tr[i].punto.y - altura;
				dibujo.push(elem[i]);
			}
			
			var point_0: Point = new Point(m.inicio.x,m.inicio.y);
			var point_1: Point = new Point(tr[0].punto.x ,tr[0].punto.y); 
			elem[i] = new Object();
			elem[i]["x"] = point_1.x - anchura;
			elem[i]["y"] = point_1.y - altura;
			dibujo.push(elem[i]);
			return dibujo;
		}
		
		//	Propery to show paths
		public function set ShowPaths(value: Boolean): void{
			for(var i: uint = 1; i < ej.escenas.length; i++){
				var es: EscenaBE = ej.escenas[i];
				for(var j: uint = 0; j < es.movimientos.length; j++ ){
					paths[i][j].visible = value;
				}
			}
		}
		
		//	Property to show Points
		public function set ShowPoints(value: Boolean): void{
			for(var i: uint = 1; i < ej.escenas.length; i++){
				var es: EscenaBE = ej.escenas[i];
				for(var j: uint = 0; j < es.movimientos.length; j++ ){
					paths[i][j].PointVisibility = value;
				}
			}
		}
	
	}
	
}